import 'dart:convert';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/model/global/response_model/response_model.dart';
import 'package:viserpay_agent/data/model/transctions/transaction_response_model.dart' as transaction;
import 'package:viserpay_agent/data/repo/transaction/transaction_repo.dart';
import 'package:viserpay_agent/view/components/snack_bar/show_custom_snackbar.dart';

class TransactionHistoryController extends GetxController {
  TransactionRepo transactionRepo;
  TransactionHistoryController({required this.transactionRepo});

  bool isLoading = true;

  List<String> transactionTypeList = [MyStrings.allType, MyStrings.plus, MyStrings.minus];
  List<String> operationTypeList = [];
  List<String> historyFormList = [];

  List<transaction.Data> transactionList = [];

  String trxSearchText = "";
  String? nextPageUrl;
  int page = 0;
  String currency = "";
  String currencySym = "";

  TextEditingController trxController = TextEditingController();

  String selectedTransactionType = MyStrings.allType;
  String selectedOperationType = "";
  String selectedHistoryFrom = MyStrings.allTime;

  setSelectedTransactionType(String? trxType) {
    selectedTransactionType = trxType ?? "";
    update();
  }

  setSelectedOperationType(String? operationType) {
    selectedOperationType = operationType ?? "";
    update();
  }

  setSelectedHistoryFrom(String? historyFrom) {
    selectedHistoryFrom = historyFrom!;

    update();
  }

  void loadDefaultData(String trxType) {
    if (trxType.isNotEmpty) {
      trxType.toLowerCase() == MyStrings.plus.toLowerCase() || trxType.toLowerCase() == MyStrings.minus.toLowerCase() ? setSelectedTransactionType(trxType) : setSelectedOperationType(trxType);
    } else {
      selectedTransactionType = MyStrings.allType;
      selectedOperationType = MyStrings.allOperation;
    }

    initialSelectedValue();
  }

  void initialSelectedValue() async {
    page = 0;
    selectedHistoryFrom = "";
    currency = transactionRepo.apiClient.getCurrencyOrUsername(isCurrency: true);
    currencySym = transactionRepo.apiClient.getCurrencyOrUsername(isSymbol: true);
    trxController.text = "";
    trxSearchText = "";
    transactionList.clear();

    isLoading = true;
    update();
    await loadTransactionData();
    isLoading = false;
    update();
  }

  Future<void> loadTransactionData() async {
    String trxType = Get.arguments ?? '';
    if (trxType.isNotEmpty) {
      trxType.toLowerCase() == MyStrings.plus.toLowerCase() || trxType.toLowerCase() == MyStrings.minus.toLowerCase() ? setSelectedTransactionType(trxType) : setSelectedOperationType(trxType);
    }
    page = page + 1;
    if (page == 1) {
      operationTypeList.clear();
      historyFormList.clear();
      transactionList.clear();

      operationTypeList.insert(0, MyStrings.allOperation);
      historyFormList.insert(0, MyStrings.allTime);
      update();
    }

    ResponseModel responseModel = await transactionRepo.getTransactionData(
      page,
      searchText: trxSearchText,
      transactionType: selectedTransactionType.toLowerCase(),
      operationType: selectedOperationType.toLowerCase(),
      historyFrom: selectedHistoryFrom.toLowerCase(),
    );

    if (responseModel.statusCode == 200) {
      transaction.TransactionResponseModel model = transaction.TransactionResponseModel.fromJson(jsonDecode(responseModel.responseJson));
      nextPageUrl = model.data?.transactions?.nextPageUrl;

      if (model.status.toString().toLowerCase() == "success") {
        List<transaction.Data>? tempDataList = model.data?.transactions?.data;
        if (tempDataList != null && tempDataList.isNotEmpty) {
          transactionList.addAll(tempDataList);
        }

        List<String>? tempHistoryTime = model.data?.times;
        if (tempHistoryTime != null || tempHistoryTime!.isNotEmpty) {
          historyFormList.clear();
          historyFormList.insert(0, MyStrings.allTime);
          historyFormList.addAll(tempHistoryTime);
        }

        List<String>? teampRemarks = model.data?.remarks;
        if (teampRemarks != null || teampRemarks!.isNotEmpty) {
          operationTypeList.clear();
          operationTypeList.addAll(teampRemarks);
          operationTypeList.insert(0, MyStrings.allOperation);
          selectedOperationType = operationTypeList[0];
          setSelectedOperationType(selectedOperationType);
        }
      } else {
        CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }

    update();
  }

  Future<void> loadFilteredTransactions() async {
    page = page + 1;

    if (page == 1) {
      transactionList.clear();
    }

    ResponseModel responseModel = await transactionRepo.getTransactionData(
      page,
      searchText: trxSearchText,
      transactionType: selectedTransactionType.toLowerCase(),
      operationType: selectedOperationType.toLowerCase(),
      historyFrom: selectedHistoryFrom.toLowerCase(),
    );

    if (responseModel.statusCode == 200) {
      transaction.TransactionResponseModel model = transaction.TransactionResponseModel.fromJson(jsonDecode(responseModel.responseJson));
      nextPageUrl = model.data?.transactions?.nextPageUrl;

      if (model.status.toString().toLowerCase() == "success") {
        List<transaction.Data>? tempDataList = model.data?.transactions?.data;
        if (tempDataList != null && tempDataList.isNotEmpty) {
          transactionList.addAll(tempDataList);
        }
      } else {
        CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }

    update();
  }

  bool filterLoading = false;

  Future<void> filterData() async {
    trxSearchText = trxController.text;
    page = 0;
    filterLoading = true;
    update();
    transactionList.clear();
    await loadFilteredTransactions();
    filterLoading = false;
    update();
  }

  bool hasNext() {
    return nextPageUrl != null && nextPageUrl!.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  bool isSearch = false;
  void changeSearchIcon() {
    isSearch = !isSearch;
    update();

    if (!isSearch) {
      selectedTransactionType = MyStrings.allType;
      initialSelectedValue();
    }
  }
}
